'use strict';

// Initialize app
var myApp = new Framework7({
    pushState: true,
    //pushStateSeparator: ''
    onAjaxStart: function(xhr) { myApp.showIndicator(); },
    onAjaxComplete: function(xhr) { myApp.hideIndicator(); }
});

// If we need to use custom DOM library, let's save it to $$ variable:
var $$ = Dom7;

// Add view
var mainView = myApp.addView('.view-main', {
    dynamicNavbar: true,
    //domCache: true
});

myApp.onPageInit('index', function(page) {

    var loading = false;
    var lastIndex = $$('.index .list-block.index-list li').length;
    //var maxItems = 60;
    var itemsPerLoad = 10;
    var pageIndex = 1;

    if (lastIndex < itemsPerLoad) {
        myApp.detachInfiniteScroll($$('.index .infinite-scroll'));
        $$('.index .infinite-scroll-preloader').hide();
    }

    // Attach 'infinite' event handler
    $$('.index .infinite-scroll').on('infinite', function() {

        // Exit, if loading in progress
        if (loading) return;

        // Set loading flag
        loading = true;

        // Emulate 1s loading
        setTimeout(function() {
            // Reset loading flag
            loading = false;

            $$.ajax({
                url: 'pda.php',
                type: 'POST',
                dataType: 'html',
                data: {
                    op: 'load_more',
                    num: itemsPerLoad,
                    p: pageIndex
                },
                success: function(data) {
                    if (data.length) {
                        $$('.index .list-block.index-list ul').append(data);
                        myApp.initImagesLazyLoad('.index .list-block.index-list img.lazy');
                        pageIndex++;
                        lastIndex = $$('.index .list-block.index-list li').length;
                    } else {
                        myApp.detachInfiniteScroll($$('.index .infinite-scroll'));
                        $$('.index .infinite-scroll-preloader').hide();
                        return;
                    }
                },
                error: function(data) {
                    //console.log("error");
                }
            });

        }, 1000);
    });

    // Pull to refresh content
    var ptrContent = $$('.index .pull-to-refresh-content');

    // Add 'refresh' listener on it
    ptrContent.on('refresh', function(e) {

        // Emulate 2s loading
        setTimeout(function() {

            $$.ajax({
                url: 'pda.php',
                type: 'POST',
                dataType: 'html',
                data: {
                    op: 'load_more',
                    num: itemsPerLoad,
                    p: 0
                },
                success: function(data) {
                    $$('.index .list-block.index-list ul').html(data);
                    myApp.initImagesLazyLoad('.index .list-block.index-list img.lazy');
                    pageIndex = 1;
                    if (lastIndex >= itemsPerLoad) {
                        myApp.attachInfiniteScroll($$('.index .infinite-scroll'));
                        $$('.index .infinite-scroll-preloader').show();
                    }
                },
                error: function(data) {
                    //console.log("error");
                }
            });

            // When loading done, we need to reset it
            myApp.pullToRefreshDone();
        }, 2000);

    });
}).trigger();

myApp.onPageInit('category', function(page) {
    myApp.closePanel();

    var loading = false;
    var ncsn = page.query.ncsn;
    var lastIndex = $$('.category' + ncsn + ' .list-block.cate-list li').length;
    //var maxItems = 60;
    var itemsPerLoad = 10;
    var pageIndex = 1;

    if (lastIndex < itemsPerLoad) {
        myApp.detachInfiniteScroll($$('.category' + ncsn + ' .infinite-scroll'));
        $$('.category' + ncsn + ' .infinite-scroll-preloader').hide();
    }

    // Attach 'infinite' event handler
    $$('.category' + ncsn + ' .infinite-scroll').on('infinite', function() {

        // Exit, if loading in progress
        if (loading) return;

        // Set loading flag
        loading = true;

        // Emulate 1s loading
        setTimeout(function() {
            // Reset loading flag
            loading = false;

            $$.ajax({
                url: 'pda.php',
                type: 'POST',
                dataType: 'html',
                data: {
                    op: 'load_more',
                    num: itemsPerLoad,
                    p: pageIndex,
                    ncsn: ncsn
                },
                success: function(data) {
                    if (data.length) {
                        $$('.category' + ncsn + ' .list-block.cate-list ul').append(data);
                        myApp.initImagesLazyLoad('.category' + ncsn + ' .list-block.cate-list img.lazy');
                        pageIndex++;
                        lastIndex = $$('.category' + ncsn + ' .list-block.cate-list li').length;
                    } else {
                        myApp.detachInfiniteScroll($$('.category' + ncsn + ' .infinite-scroll'));
                        $$('.category' + ncsn + ' .infinite-scroll-preloader').hide();
                        return;
                    }
                },
                error: function(data) {
                    //console.log("error");
                }
            });

        }, 1000);
    });

    // Pull to refresh content
    var ptrContent = $$('.category' + ncsn + ' .pull-to-refresh-content');

    // Add 'refresh' listener on it
    ptrContent.on('refresh', function(e) {

        // Emulate 2s loading
        setTimeout(function() {

            $$.ajax({
                url: 'pda.php',
                type: 'POST',
                dataType: 'html',
                data: {
                    op: 'load_more',
                    num: itemsPerLoad,
                    p: 0,
                    ncsn: ncsn
                },
                success: function(data) {
                    $$('.category' + ncsn + ' .list-block.cate-list ul').html(data);
                    $$('.category' + ncsn + ' .list-block.cate-list img.lazy').trigger('lazy');
                    pageIndex = 1;
                    if (lastIndex >= itemsPerLoad) {
                        myApp.attachInfiniteScroll($$('.category' + ncsn + ' .infinite-scroll'));
                        $$('.category' + ncsn + ' .infinite-scroll-preloader').show();
                    }
                },
                error: function(data) {
                    //console.log("error");
                }
            });

            // When loading done, we need to reset it
            myApp.pullToRefreshDone();
        }, 2000);

    });
});

myApp.onPageInit('newspaper', function(page) {
    myApp.closePanel();
});

myApp.onPageInit('month', function(page) {
    myApp.closePanel();
});

myApp.onPageInit('member', function(page) {
    myApp.closePanel();
});

myApp.onPageInit('show', function(page) {
    //內文按鈕樣式替換
    $$('#news-read-check .btn').removeClass('btn btn-primary btn-large').addClass('button button-big button-fill color-orange external');
    $$('#news-toolbar .btn-group').removeClass('btn-group').addClass('buttons-row');
    //內文外連處理
    $$('#news-content').find('a').addClass('external').attr('target', '_blank');
    //隱藏刪除按鈕
    $$('#news-toolbar .btn').removeClass('btn btn-default btn-xs').addClass('button external').eq(-3).attr('style', 'display:none');
    //prefix_tag連結
    $$('#news-info .label').addClass('external');
    //附檔顯示問題
    $$('#news-attach .thumbnail').css('display', 'block').addClass('external');
    //附檔fancybox plugin
    $('#news-attach .fancybox_nsn').fancybox({
        fitToView: true,
        width: '640',
        height: '480',
        autoSize: false,
        closeClick: false,
        openEffect: 'none',
        closeEffect: 'none'
    });
    //facebook comment plugin
    if ($('#fb-root').length > 0) {
        $('#fb-root').detach();
        $.ajaxSetup({ cache: true });
        $.getScript('//connect.facebook.net/zh_TW/sdk.js', function() {
            FB.init({
                xfbml: true,
                appId: '199288920104939',
                version: 'v2.3'
            });
        });
    }
});
