<?php
/**
 * Ben Score module
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting source code
 * which is considered copyrighted (c) material of the original comment or credit authors.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @copyright  The XOOPS Project http://sourceforge.net/projects/xoops/
 * @license    http://www.fsf.org/copyleft/gpl.html GNU public license
 * @package    Ben Score
 * @since      2.5
 * @author     Benjamin
 * @version    $Id $
 **/


/*-----------引入檔案區--------------*/
$isAdmin=true;
$xoopsOption['template_main'] = 'ben_score_adm_teacher.html';
include_once "header.php";
include_once "../function.php";

/*-----------功能函數區--------------*/


//ben_score_teacher編輯表單
function ben_score_teacher_form($bs_teacher_sn = '')
{
    global $xoopsDB, $xoopsTpl, $isAdmin;

    if(!$isAdmin)
    {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }

    include_once(XOOPS_ROOT_PATH."/class/xoopsformloader.php");
    include_once(XOOPS_ROOT_PATH."/class/xoopseditor/xoopseditor.php");

    //抓取預設值
    if(!empty($bs_teacher_sn))
    {
        $DBV = get_ben_score_teacher($bs_teacher_sn);
    }else{
        $DBV = array();
    }

    //預設值設定
        
    //設定 bs_teacher_id 欄位的預設值
    $bs_teacher_id = !isset($DBV['bs_teacher_id']) ? "" : $DBV['bs_teacher_id'];
    $xoopsTpl->assign('bs_teacher_id', $bs_teacher_id);    
    //設定 bs_teacher_sn 欄位的預設值
    $bs_teacher_sn = !isset($DBV['bs_teacher_sn']) ? $bs_teacher_sn : $DBV['bs_teacher_sn'];
    $xoopsTpl->assign('bs_teacher_sn', $bs_teacher_sn);    
    //設定 bs_teacher_cate 欄位的預設值
    $bs_teacher_cate = !isset($DBV['bs_teacher_cate']) ? "" : $DBV['bs_teacher_cate'];
    $xoopsTpl->assign('bs_teacher_cate', $bs_teacher_cate);    
    //設定 bs_teacher_name 欄位的預設值
    $bs_teacher_name = !isset($DBV['bs_teacher_name']) ? "" : $DBV['bs_teacher_name'];
    $xoopsTpl->assign('bs_teacher_name', $bs_teacher_name);    
    //設定 bs_teacher_genser 欄位的預設值
    $bs_teacher_genser = !isset($DBV['bs_teacher_genser']) ? "" : $DBV['bs_teacher_genser'];
    $xoopsTpl->assign('bs_teacher_genser', $bs_teacher_genser);    
    //設定 bs_teacher_phone 欄位的預設值
    $bs_teacher_phone = !isset($DBV['bs_teacher_phone']) ? "" : $DBV['bs_teacher_phone'];
    $xoopsTpl->assign('bs_teacher_phone', $bs_teacher_phone);    
    //設定 bs_teacher_country 欄位的預設值
    $bs_teacher_country = !isset($DBV['bs_teacher_country']) ? "" : $DBV['bs_teacher_country'];
    $xoopsTpl->assign('bs_teacher_country', $bs_teacher_country);    
    //設定 bs_teacher_code 欄位的預設值
    $bs_teacher_code = !isset($DBV['bs_teacher_code']) ? "" : $DBV['bs_teacher_code'];
    $xoopsTpl->assign('bs_teacher_code', $bs_teacher_code);    
    //設定 bs_teacher_city 欄位的預設值
    $bs_teacher_city = !isset($DBV['bs_teacher_city']) ? "" : $DBV['bs_teacher_city'];
    $xoopsTpl->assign('bs_teacher_city', $bs_teacher_city);    
    //設定 bs_teacher_address 欄位的預設值
    $bs_teacher_address = !isset($DBV['bs_teacher_address']) ? "" : $DBV['bs_teacher_address'];
    $xoopsTpl->assign('bs_teacher_address', $bs_teacher_address);    
    //設定 bs_teacher_dept 欄位的預設值
    $bs_teacher_dept = !isset($DBV['bs_teacher_dept']) ? "" : $DBV['bs_teacher_dept'];
    $xoopsTpl->assign('bs_teacher_dept', $bs_teacher_dept);    
    //設定 bs_teacher_hiredate 欄位的預設值
    $bs_teacher_hiredate = !isset($DBV['bs_teacher_hiredate']) ? date("Y-m-d") : $DBV['bs_teacher_hiredate'];
    $xoopsTpl->assign('bs_teacher_hiredate', $bs_teacher_hiredate);    
    //設定 bs_teacher_picture 欄位的預設值
    $bs_teacher_picture = !isset($DBV['bs_teacher_picture']) ? "" : $DBV['bs_teacher_picture'];
    $xoopsTpl->assign('bs_teacher_picture', $bs_teacher_picture);    
    //設定 bs_teacher_memo 欄位的預設值
    $bs_teacher_memo = !isset($DBV['bs_teacher_memo']) ? "" : $DBV['bs_teacher_memo'];
    $xoopsTpl->assign('bs_teacher_memo', $bs_teacher_memo);    
    //設定 bs_teacher_enable 欄位的預設值
    $bs_teacher_enable = !isset($DBV['bs_teacher_enable']) ? "" : $DBV['bs_teacher_enable'];
    $xoopsTpl->assign('bs_teacher_enable', $bs_teacher_enable);    
    //設定 bs_teacher_keyindate 欄位的預設值
    $bs_teacher_keyindate = !isset($DBV['bs_teacher_keyindate']) ? date("Y-m-d H:i:s") : $DBV['bs_teacher_keyindate'];
    $xoopsTpl->assign('bs_teacher_keyindate', $bs_teacher_keyindate);

    $op = empty($bs_teacher_sn) ? "insert_ben_score_teacher" : "update_ben_score_teacher";
    //$op="replace_ben_score_teacher";
    
    $span = $_SESSION['bootstrap'] == '3' ? 'form-control col-md-' : 'span';
    $form = new XoopsThemeForm('', 'form', $_SERVER['PHP_SELF'], 'post', true);
    $form->setExtra('enctype = "multipart/form-data"');

    //身份證號
    $bs_teacher_idText = new XoopsFormText(_MA_BENSCORE_BS_TEACHER_ID, "bs_teacher_id", 25, 255, $bs_teacher_id);
    $bs_teacher_idText->setExtra("class = '{$span}5'");
    $form->addElement($bs_teacher_idText, false);

    //教師編號
    $form->addElement(new XoopsFormHidden("bs_teacher_sn", $bs_teacher_sn));

    //教師分類
    $bs_teacher_cateSelect = new XoopsFormSelect(_MA_BENSCORE_BS_TEACHER_CATE, 'bs_teacher_cate', '', 1, false);
    $options_array = "";
    $options_array['專任'] = '專任';
    $options_array['代理'] = '代理';
    $options_array['兼任'] = '兼任';
    $options_array['基金會聘任'] = '基金會聘任';
    $bs_teacher_cateSelect->addOptionArray($options_array);
    $bs_teacher_cateSelect->setExtra("class = '{$span}5'");
    $form->addElement($bs_teacher_cateSelect, false);

    //教師姓名
    $bs_teacher_nameText = new XoopsFormText(_MA_BENSCORE_BS_TEACHER_NAME, "bs_teacher_name", 25, 255, $bs_teacher_name);
    $bs_teacher_nameText->setExtra("class = '{$span}5'");
    $form->addElement($bs_teacher_nameText, false);

    //教師性別
    $bs_teacher_genserSelect = new XoopsFormSelect(_MA_BENSCORE_BS_TEACHER_GENSER, 'bs_teacher_genser', '', 1, false);
    $options_array = "";
    $options_array['男'] = '男';
    $options_array['女'] = '女';
    $bs_teacher_genserSelect->addOptionArray($options_array);
    $bs_teacher_genserSelect->setExtra("class = '{$span}1'");
    $form->addElement($bs_teacher_genserSelect, false);

    //聯絡電話
    $bs_teacher_phoneText = new XoopsFormText(_MA_BENSCORE_BS_TEACHER_PHONE, "bs_teacher_phone", 50, 255, $bs_teacher_phone);
    $bs_teacher_phoneText->setExtra("class = '{$span}10'");
    $form->addElement($bs_teacher_phoneText, false);

    //國籍別
    $bs_teacher_countryText = new XoopsFormText(_MA_BENSCORE_BS_TEACHER_COUNTRY, "bs_teacher_country", 25, 255, $bs_teacher_country);
    $bs_teacher_countryText->setExtra("class = '{$span}5'");
    $form->addElement($bs_teacher_countryText, false);

    //地址
    $bs_teacher_address_Code = new XoopsFormLabel(_MA_BENSCORE_BS_TEACHER_ADDRESS, "<div class='col-md-5' id='twzipcode'></div><div class='col-md-7'><input type='text' name='bs_teacher_address' id='bs_teacher_address' class='form-control' value='$bs_teacher_address' placeholder='_MA_BENSCORE_BS_TEACHER_ADDRESS'></div></div>");
    $form->addElement($bs_teacher_address_Code, false);

    //所屬處室
    $bs_teacher_deptSelect = new XoopsFormSelect(_MA_BENSCORE_BS_TEACHER_DEPT, 'bs_teacher_dept', '', 1, false);
    $options_array = "";
    $options_array['教務處'] = '教務處';
    $options_array['學務處'] = '學務處';
    $options_array['總務處'] = '總務處';
    $options_array['輔導室'] = '輔導室';
    $options_array['舞蹈科'] = '舞蹈科';
    $options_array['美術科'] = '美術科';
    $options_array['音樂科'] = '音樂科';
    $options_array['普通班'] = '普通班';
    $bs_teacher_deptSelect->addOptionArray($options_array);
    $bs_teacher_deptSelect->setExtra("class = '{$span}5'");
    $form->addElement($bs_teacher_deptSelect, false);

    /*送出後，取得時間值的方法：
    $all_time = strtotime($_POST['bs_teacher_hiredate']['date']) + $_POST['bs_teacher_hiredate']['time'];
    $day = date("Y-m-d", $all_time); */
    $bs_teacher_hiredate_timestamp = !empty($bs_teacher_hiredate) ? strtotime($bs_teacher_hiredate) : time();
    $bs_teacher_hiredateDateTime = new XoopsFormDateTime(_MA_BENSCORE_BS_TEACHER_HIREDATE, "bs_teacher_hiredate", 25, $bs_teacher_hiredate_timestamp);
    $bs_teacher_hiredateDateTime->setExtra("class = '{$span}5'");
    $form->addElement($bs_teacher_hiredateDateTime, false);

    //教師照片
    $form->addElement(new XoopsFormHidden("bs_teacher_picture", $bs_teacher_picture));

    //教師備註
    $bs_teacher_memoText = new XoopsFormText(_MA_BENSCORE_BS_TEACHER_MEMO, "bs_teacher_memo", 50, 255, $bs_teacher_memo);
    $bs_teacher_memoText->setExtra("class = '{$span}10'");
    $form->addElement($bs_teacher_memoText, false);

    //聘任否
    $bs_teacher_enableRadio = new XoopsFormRadio(_MA_BENSCORE_BS_TEACHER_ENABLE, 'bs_teacher_enable', '');
    $options_array['聘任'] = '聘任';
    $options_array['不聘任'] = '不聘任';
    $bs_teacher_enableRadio->addOptionArray($options_array);
    $form->addElement($bs_teacher_enableRadio, false);

    //照片上傳
    include_once XOOPS_ROOT_PATH."/modules/tadtools/TadUpFiles.php" ;
    $TadUpFiles = new TadUpFiles("ben_score");
    $TadUpFiles->set_col("bs_teacher_sn",$bs_teacher_sn);
    $up_bs_teacher_sn_form = $TadUpFiles->upform(false, "up_bs_teacher_sn", "1");
    $bs_teacher_sn_up = new XoopsFormLabel(_MA_BENSCORE_UP_BS_TEACHER_SN, $up_bs_teacher_sn_form);
    $form->addElement($bs_teacher_sn_up, false);
    $form->addElement(new XoopsFormHidden("op", $op));
    $form->addElement(new XoopsFormHiddenToken());

    $SubmitTray=new XoopsFormElementTray('', '', '', true);
    $SubmitTray->addElement(new XoopsFormButton('', '', _TAD_SUBMIT, 'submit'));
    $form->addElement($SubmitTray);
    $xoopsform = $form->render();
    $xoopsTpl->assign('xoopsform', $xoopsform);

    $xoopsTpl->assign('now_op', 'ben_score_teacher_form');
    $xoopsTpl->assign('next_op', $op);
}



//以流水號取得某筆ben_score_teacher資料
function get_ben_score_teacher($bs_teacher_sn = '')
{
    global $xoopsDB;

    if(empty($bs_teacher_sn))
    {
        return;
    }

    $sql = "select * from `".$xoopsDB->prefix("ben_score_teacher")."`
    where `bs_teacher_sn` = '{$bs_teacher_sn}'";
    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    $data = $xoopsDB->fetchArray($result);
    return $data;
}

//新增資料到ben_score_teacher中
function insert_ben_score_teacher()
{
    global $xoopsDB, $xoopsUser, $isAdmin;
    if(!$isAdmin) {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }

    
    //XOOPS表單安全檢查
    if(!$GLOBALS['xoopsSecurity']->check())
    {
        $error=implode("<br />", $GLOBALS['xoopsSecurity']->getErrors());
        redirect_header($_SERVER['PHP_SELF'], 3, $error);
    }

    $myts = MyTextSanitizer::getInstance();
    
    $bs_teacher_id = $myts->addSlashes($_POST['bs_teacher_id']);
    $bs_teacher_sn = intval($_POST['bs_teacher_sn']);
    $bs_teacher_cate = $_POST['bs_teacher_cate'];
    $bs_teacher_name = $myts->addSlashes($_POST['bs_teacher_name']);
    $bs_teacher_genser = $_POST['bs_teacher_genser'];
    $bs_teacher_phone = $myts->addSlashes($_POST['bs_teacher_phone']);
    $bs_teacher_country = $myts->addSlashes($_POST['bs_teacher_country']);
    $bs_teacher_code = $_POST['bs_teacher_code'];
    $bs_teacher_city = $_POST['bs_teacher_city'];
    $bs_teacher_address = $_POST['bs_teacher_address'];
    $bs_teacher_dept = $_POST['bs_teacher_dept'];
    $bs_teacher_hiredate = $myts->addSlashes($_POST['bs_teacher_hiredate']);
    $bs_teacher_picture = $_POST['bs_teacher_picture'];
    $bs_teacher_memo = $myts->addSlashes($_POST['bs_teacher_memo']);
    $bs_teacher_enable = $_POST['bs_teacher_enable'];
    $bs_teacher_keyindate = date("Y-m-d H:i:s",xoops_getUserTimestamp(time()));

    $sql = "insert into `".$xoopsDB->prefix("ben_score_teacher")."` (
        `bs_teacher_id`, 
        `bs_teacher_cate`, 
        `bs_teacher_name`, 
        `bs_teacher_genser`, 
        `bs_teacher_phone`, 
        `bs_teacher_country`, 
        `bs_teacher_code`, 
        `bs_teacher_city`, 
        `bs_teacher_address`, 
        `bs_teacher_dept`, 
        `bs_teacher_hiredate`, 
        `bs_teacher_picture`, 
        `bs_teacher_memo`, 
        `bs_teacher_enable`, 
        `bs_teacher_keyindate`
    ) values(
        '{$bs_teacher_id}', 
        '{$bs_teacher_cate}', 
        '{$bs_teacher_name}', 
        '{$bs_teacher_genser}', 
        '{$bs_teacher_phone}', 
        '{$bs_teacher_country}', 
        '{$bs_teacher_code}', 
        '{$bs_teacher_city}', 
        '{$bs_teacher_address}', 
        '{$bs_teacher_dept}', 
        '{$bs_teacher_hiredate}', 
        '{$bs_teacher_picture}', 
        '{$bs_teacher_memo}', 
        '{$bs_teacher_enable}', 
        '{$bs_teacher_keyindate}'
    )";
    $xoopsDB->query($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());

    //取得最後新增資料的流水編號
    $bs_teacher_sn = $xoopsDB->getInsertId();
    
    include_once XOOPS_ROOT_PATH."/modules/tadtools/TadUpFiles.php" ;
    $TadUpFiles = new TadUpFiles("ben_score");
    $TadUpFiles->set_col("bs_teacher_sn", $bs_teacher_sn);
    $TadUpFiles->upload_file('up_bs_teacher_sn', '', '', '', '', false, false);
    return $bs_teacher_sn;
}

//更新ben_score_teacher某一筆資料
function update_ben_score_teacher($bs_teacher_sn = '')
{
    global $xoopsDB, $isAdmin, $xoopsUser;
    if(!$isAdmin)
    {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }
    
    //XOOPS表單安全檢查
    if(!$GLOBALS['xoopsSecurity']->check())
    {
        $error = implode("<br />", $GLOBALS['xoopsSecurity']->getErrors());
        redirect_header($_SERVER['PHP_SELF'], 3, $error);
    }

    $myts = MyTextSanitizer::getInstance();
    
    $bs_teacher_id = $myts->addSlashes($_POST['bs_teacher_id']);
    $bs_teacher_sn = intval($_POST['bs_teacher_sn']);
    $bs_teacher_cate = $_POST['bs_teacher_cate'];
    $bs_teacher_name = $myts->addSlashes($_POST['bs_teacher_name']);
    $bs_teacher_genser = $_POST['bs_teacher_genser'];
    $bs_teacher_phone = $myts->addSlashes($_POST['bs_teacher_phone']);
    $bs_teacher_country = $myts->addSlashes($_POST['bs_teacher_country']);
    $bs_teacher_code = $_POST['bs_teacher_code'];
    $bs_teacher_city = $_POST['bs_teacher_city'];
    $bs_teacher_address = $_POST['bs_teacher_address'];
    $bs_teacher_dept = $_POST['bs_teacher_dept'];
    $bs_teacher_hiredate = $myts->addSlashes($_POST['bs_teacher_hiredate']);
    $bs_teacher_picture = $_POST['bs_teacher_picture'];
    $bs_teacher_memo = $myts->addSlashes($_POST['bs_teacher_memo']);
    $bs_teacher_enable = $_POST['bs_teacher_enable'];
    $bs_teacher_keyindate = date("Y-m-d H:i:s",xoops_getUserTimestamp(time()));

    $sql = "update `".$xoopsDB->prefix("ben_score_teacher")."` set 
       `bs_teacher_id` = '{$bs_teacher_id}', 
       `bs_teacher_cate` = '{$bs_teacher_cate}', 
       `bs_teacher_name` = '{$bs_teacher_name}', 
       `bs_teacher_genser` = '{$bs_teacher_genser}', 
       `bs_teacher_phone` = '{$bs_teacher_phone}', 
       `bs_teacher_country` = '{$bs_teacher_country}', 
       `bs_teacher_code` = '{$bs_teacher_code}', 
       `bs_teacher_city` = '{$bs_teacher_city}', 
       `bs_teacher_address` = '{$bs_teacher_address}', 
       `bs_teacher_dept` = '{$bs_teacher_dept}', 
       `bs_teacher_hiredate` = '{$bs_teacher_hiredate}', 
       `bs_teacher_picture` = '{$bs_teacher_picture}', 
       `bs_teacher_memo` = '{$bs_teacher_memo}', 
       `bs_teacher_enable` = '{$bs_teacher_enable}', 
       `bs_teacher_keyindate` = '{$bs_teacher_keyindate}'
    where `bs_teacher_sn` = '$bs_teacher_sn'";
    $xoopsDB->queryF($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    
    include_once XOOPS_ROOT_PATH."/modules/tadtools/TadUpFiles.php" ;
    $TadUpFiles = new TadUpFiles("ben_score");
    $TadUpFiles->set_col("bs_teacher_sn", $bs_teacher_sn);
    $TadUpFiles->upload_file('up_bs_teacher_sn', '', '', '', '', false, false);
    return $bs_teacher_sn;
}

//刪除ben_score_teacher某筆資料資料
function delete_ben_score_teacher($bs_teacher_sn = '')
{
    global $xoopsDB, $isAdmin;
    if(!$isAdmin)
    {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }

    if(empty($bs_teacher_sn))
    {
        return;
    }

    $sql = "delete from `".$xoopsDB->prefix("ben_score_teacher")."`
    where `bs_teacher_sn` = '{$bs_teacher_sn}'";
    $xoopsDB->queryF($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    
    include_once XOOPS_ROOT_PATH."/modules/tadtools/TadUpFiles.php" ;
    $TadUpFiles = new TadUpFiles("ben_score");
    $TadUpFiles->set_col("bs_teacher_sn", $bs_teacher_sn);
    $TadUpFiles->del_files();
}

//以流水號秀出某筆ben_score_teacher資料內容
function show_one_ben_score_teacher($bs_teacher_sn = '')
{
    global $xoopsDB, $xoopsTpl, $isAdmin;

    if(empty($bs_teacher_sn))
    {
        return;
    } else {
        $bs_teacher_sn = intval($bs_teacher_sn);
    }

    $myts = MyTextSanitizer::getInstance();

    $sql = "select * from `".$xoopsDB->prefix("ben_score_teacher")."`
    where `bs_teacher_sn` = '{$bs_teacher_sn}' ";
    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    $all = $xoopsDB->fetchArray($result);

    //以下會產生這些變數： $bs_teacher_id, $bs_teacher_sn, $bs_teacher_cate, $bs_teacher_name, $bs_teacher_genser, $bs_teacher_phone, $bs_teacher_country, $bs_teacher_code, $bs_teacher_city, $bs_teacher_address, $bs_teacher_dept, $bs_teacher_hiredate, $bs_teacher_picture, $bs_teacher_memo, $bs_teacher_enable, $bs_teacher_keyindate
    foreach($all as $k => $v)
    {
        $$k = $v;
    }

    
    include_once XOOPS_ROOT_PATH."/modules/tadtools/TadUpFiles.php" ;
    $TadUpFiles=new TadUpFiles("ben_score");
    $TadUpFiles->set_col("bs_teacher_sn",$bs_teacher_sn);
    $show_bs_teacher_sn_files=$TadUpFiles->show_files('up_bs_teacher_sn', true, 'thumb',true,false,NULL,NULL,false);
    $xoopsTpl->assign('show_bs_teacher_sn_files',$show_bs_teacher_sn_files);

    //過濾讀出的變數值
    $bs_teacher_id = $myts->htmlSpecialChars($bs_teacher_id);
    $bs_teacher_name = $myts->htmlSpecialChars($bs_teacher_name);
    $bs_teacher_phone = $myts->htmlSpecialChars($bs_teacher_phone);
    $bs_teacher_country = $myts->htmlSpecialChars($bs_teacher_country);
    $bs_teacher_hiredate = $myts->htmlSpecialChars($bs_teacher_hiredate);
    $bs_teacher_memo = $myts->htmlSpecialChars($bs_teacher_memo);

    $xoopsTpl->assign('bs_teacher_id', $bs_teacher_id);
    $xoopsTpl->assign('bs_teacher_sn', $bs_teacher_sn);
    $xoopsTpl->assign('bs_teacher_cate', $bs_teacher_cate);
    $xoopsTpl->assign('bs_teacher_name', $bs_teacher_name);
    $xoopsTpl->assign('bs_teacher_genser', $bs_teacher_genser);
    $xoopsTpl->assign('bs_teacher_phone', $bs_teacher_phone);
    $xoopsTpl->assign('bs_teacher_country', $bs_teacher_country);
    $xoopsTpl->assign('bs_teacher_code', $bs_teacher_code);
    $xoopsTpl->assign('bs_teacher_city', $bs_teacher_city);
    $xoopsTpl->assign('bs_teacher_address', $bs_teacher_address);
    $xoopsTpl->assign('bs_teacher_dept', $bs_teacher_dept);
    $xoopsTpl->assign('bs_teacher_hiredate', $bs_teacher_hiredate);
    $xoopsTpl->assign('bs_teacher_picture', $bs_teacher_picture);
    $xoopsTpl->assign('bs_teacher_memo', $bs_teacher_memo);
    $xoopsTpl->assign('bs_teacher_enable', $bs_teacher_enable);
    $xoopsTpl->assign('bs_teacher_keyindate', $bs_teacher_keyindate);

    if(!file_exists(XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php"))
    {
        redirect_header("index.php", 3, _MA_NEED_TADTOOLS);
    }

    include_once XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php";
    $sweet_alert_obj   = new sweet_alert();
    $delete_ben_score_teacher_func = $sweet_alert_obj->render('delete_ben_score_teacher_func', "{$_SERVER['PHP_SELF']}?op=delete_ben_score_teacher&bs_teacher_sn=", "bs_teacher_sn");
    $xoopsTpl->assign('delete_ben_score_teacher_func', $delete_ben_score_teacher_func);

    $xoopsTpl->assign('action', $_SERVER['PHP_SELF']);
    $xoopsTpl->assign('now_op', 'show_one_ben_score_teacher');
}



//列出所有ben_score_teacher資料
function list_ben_score_teacher()
{
    global $xoopsDB, $xoopsTpl, $isAdmin;

    $myts = MyTextSanitizer::getInstance();
    
    include_once XOOPS_ROOT_PATH."/modules/tadtools/TadUpFiles.php" ;
    $TadUpFiles = new TadUpFiles("ben_score");
    $sql = "select * from `".$xoopsDB->prefix("ben_score_teacher")."` ";

    //getPageBar($原sql語法, 每頁顯示幾筆資料, 最多顯示幾個頁數選項);
    $PageBar = getPageBar($sql, 20, 10, null, null, $bootstrap);
    $bar     = $PageBar['bar'];
    $sql     = $PageBar['sql'];
    $total   = $PageBar['total'];

    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    
    $all_content = '';
    $i = 0;
    while($all = $xoopsDB->fetchArray($result))
    {
        //以下會產生這些變數： $bs_teacher_id, $bs_teacher_sn, $bs_teacher_cate, $bs_teacher_name, $bs_teacher_genser, $bs_teacher_phone, $bs_teacher_country, $bs_teacher_code, $bs_teacher_city, $bs_teacher_address, $bs_teacher_dept, $bs_teacher_hiredate, $bs_teacher_picture, $bs_teacher_memo, $bs_teacher_enable, $bs_teacher_keyindate
        foreach($all as $k=>$v){
            $$k=$v;
        }
        
        //過濾讀出的變數值
        $bs_teacher_id = $myts->htmlSpecialChars($bs_teacher_id);
        $bs_teacher_name = $myts->htmlSpecialChars($bs_teacher_name);
        $bs_teacher_phone = $myts->htmlSpecialChars($bs_teacher_phone);
        $bs_teacher_country = $myts->htmlSpecialChars($bs_teacher_country);
        $bs_teacher_hiredate = $myts->htmlSpecialChars($bs_teacher_hiredate);
        $bs_teacher_memo = $myts->htmlSpecialChars($bs_teacher_memo);

        $all_content[$i]['bs_teacher_id'] = $bs_teacher_id;
        $all_content[$i]['bs_teacher_sn'] = $bs_teacher_sn;
        $all_content[$i]['bs_teacher_cate'] = $bs_teacher_cate;
        $all_content[$i]['bs_teacher_name'] = $bs_teacher_name;
        $all_content[$i]['bs_teacher_genser'] = $bs_teacher_genser;
        $all_content[$i]['bs_teacher_phone'] = $bs_teacher_phone;
        $all_content[$i]['bs_teacher_country'] = $bs_teacher_country;
        $all_content[$i]['bs_teacher_code'] = $bs_teacher_code;
        $all_content[$i]['bs_teacher_city'] = $bs_teacher_city;
        $all_content[$i]['bs_teacher_address'] = $bs_teacher_address;
        $all_content[$i]['bs_teacher_dept'] = $bs_teacher_dept;
        $all_content[$i]['bs_teacher_hiredate'] = $bs_teacher_hiredate;
        $all_content[$i]['bs_teacher_picture'] = $bs_teacher_picture;
        $all_content[$i]['bs_teacher_memo'] = $bs_teacher_memo;
        $all_content[$i]['bs_teacher_enable'] = $bs_teacher_enable;
        $all_content[$i]['bs_teacher_keyindate'] = $bs_teacher_keyindate;
        $TadUpFiles->set_col("bs_teacher_sn", $bs_teacher_sn);
        $show_files=$TadUpFiles->show_files('up_bs_teacher_sn', true, 'small', false, false, NULL, NULL, false);
        $all_content[$i]['list_file'] = $show_files;
        $i++;
    }

    //刪除確認的JS
    if(!file_exists(XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php"))
    {
        redirect_header("index.php", 3, _MA_NEED_TADTOOLS);
    }
    include_once XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php";
    $sweet_alert_obj   = new sweet_alert();
    $delete_ben_score_teacher_func = $sweet_alert_obj->render('delete_ben_score_teacher_func',
    "{$_SERVER['PHP_SELF']}?op=delete_ben_score_teacher&bs_teacher_sn=", "bs_teacher_sn");
    $xoopsTpl->assign('delete_ben_score_teacher_func', $delete_ben_score_teacher_func);
    
    $xoopsTpl->assign('bar', $bar);
    $xoopsTpl->assign('action', $_SERVER['PHP_SELF']);
    $xoopsTpl->assign('isAdmin', $isAdmin);
    $xoopsTpl->assign('all_content', $all_content);
    $xoopsTpl->assign('now_op', 'list_ben_score_teacher');
}




/*-----------執行動作判斷區----------*/
include_once $GLOBALS['xoops']->path( '/modules/system/include/functions.php' );
$op = system_CleanVars($_REQUEST, 'op', '', 'string');
$bs_student_sn = system_CleanVars($_REQUEST, 'bs_student_sn', '', 'int');
$bs_teacher_sn = system_CleanVars($_REQUEST, 'bs_teacher_sn', '', 'int');
$bs_course_sn = system_CleanVars($_REQUEST, 'bs_course_sn', '', 'int');
$bs_select_course_sn = system_CleanVars($_REQUEST, 'bs_select_course_sn', '', 'int');
$bs_comment_sn = system_CleanVars($_REQUEST, 'bs_comment_sn', '', 'int');
$CREATETABLEben_score_files_centerfiles_snsmallint5unsignedNOTNULLAUTO_INCREMENTCOMMENT'檔案流水號'col_namevarchar255NOTNULLdefault''COMMENT'欄位名稱'col_snsmallint5unsignedNOTNULLdefault0COMMENT'欄位編號'sortsmallint5unsignedNOTNULLdefault0COMMENT'排序'kindenum'img''file'NOTNULLdefault'img'COMMENT'檔案種類'file_namevarchar255NOTNULLdefault''COMMENT'檔案名稱'file_typevarchar255NOTNULLdefault''COMMENT'檔案類型'file_sizeint10unsignedNOTNULLdefault0COMMENT'檔案大小'descriptiontextNOTNULLCOMMENT'檔案說明'countermediumint8unsignedNOTNULLdefault0COMMENT'下載人次'original_filenamevarchar255NOTNULLdefault''COMMENT'檔案名稱'hash_filenamevarchar255NOTNULLdefault''COMMENT'加密檔案名稱'sub_dirvarchar255NOTNULLdefault''COMMENT'檔案子路徑'files_snENGINE=MyISAM; = system_CleanVars($_REQUEST, 'CREATETABLEben_score_files_centerfiles_snsmallint5unsignedNOTNULLAUTO_INCREMENTCOMMENT'檔案流水號'col_namevarchar255NOTNULLdefault''COMMENT'欄位名稱'col_snsmallint5unsignedNOTNULLdefault0COMMENT'欄位編號'sortsmallint5unsignedNOTNULLdefault0COMMENT'排序'kindenum'img''file'NOTNULLdefault'img'COMMENT'檔案種類'file_namevarchar255NOTNULLdefault''COMMENT'檔案名稱'file_typevarchar255NOTNULLdefault''COMMENT'檔案類型'file_sizeint10unsignedNOTNULLdefault0COMMENT'檔案大小'descriptiontextNOTNULLCOMMENT'檔案說明'countermediumint8unsignedNOTNULLdefault0COMMENT'下載人次'original_filenamevarchar255NOTNULLdefault''COMMENT'檔案名稱'hash_filenamevarchar255NOTNULLdefault''COMMENT'加密檔案名稱'sub_dirvarchar255NOTNULLdefault''COMMENT'檔案子路徑'files_snENGINE=MyISAM;', '', 'int');


switch($op){
  /*---判斷動作請貼在下方---*/

  
    //替換資料
    //case "replace_ben_score_teacher":
    //    replace_ben_score_teacher();
    //    header("location: {$_SERVER['PHP_SELF']}?bs_teacher_sn=$bs_teacher_sn");
    //    exit;
    //break;

    //新增資料
    case "insert_ben_score_teacher":
        $bs_teacher_sn = insert_ben_score_teacher();
        header("location: {$_SERVER['PHP_SELF']}?bs_teacher_sn=$bs_teacher_sn");
        exit;
    break;

    //更新資料
    case "update_ben_score_teacher":
        update_ben_score_teacher($bs_teacher_sn);
        header("location: {$_SERVER['PHP_SELF']}?bs_teacher_sn=$bs_teacher_sn");
        exit;
    break;

    
    case "ben_score_teacher_form":
        ben_score_teacher_form($bs_teacher_sn);
    break;

    
    case "delete_ben_score_teacher":
        delete_ben_score_teacher($bs_teacher_sn);
        header("location: {$_SERVER['PHP_SELF']}");
        exit;
    break;
    
    //下載檔案
    case "tufdl":
    include_once XOOPS_ROOT_PATH."/modules/tadtools/TadUpFiles.php";
    $TadUpFiles=new TadUpFiles("ben_score");
    $TadUpFiles->add_file_counter($files_sn, false);
    exit;
    break;
    

    
    default:
        if(empty($bs_teacher_sn)) {
            list_ben_score_teacher();
            //$main .= ben_score_teacher_form($bs_teacher_sn);
        }else{
            show_one_ben_score_teacher($bs_teacher_sn);
        }
    break;


  /*---判斷動作請貼在上方---*/
}

/*-----------秀出結果區--------------*/
$xoopsTpl->assign("isAdmin" , true);
$xoTheme->addStylesheet(XOOPS_URL.'/modules/tadtools/css/xoops_adm.css');
include_once 'footer.php';