<!-- SmartMenus jQuery init -->
<script type="text/javascript">
    // SmartMenus init
    $(function() {
      $('#main-menu').smartmenus({
        subMenusSubOffsetX: 1,
        subMenusSubOffsetY: -8
      });
    });

    // SmartMenus mobile menu toggle button
    $(function() {
      var $mainMenuState = $('#main-menu-state');
      if ($mainMenuState.length) {
        // animate mobile menu
        $mainMenuState.change(function(e) {
          var $menu = $('#main-menu');
          if (this.checked) {
            $menu.hide().slideDown(250, function() { $menu.css('display', ''); });
          } else {
            $menu.show().slideUp(250, function() { $menu.css('display', ''); });
          }
        });
        // hide mobile menu beforeunload
        $(window).bind('beforeunload unload', function() {
          if ($mainMenuState[0].checked) {
            $mainMenuState[0].click();
          }
        });
      }
    });
</script>

<nav class="main-nav" role="navigation">
  <!-- Sample menu definition -->
  <ul id="main-menu" class="sm sm-blue">
        <{foreach item=item from=$navitems}>
          <li>
            <{if $item.menu}>
                <a href="<{$item.link}>" title="<{$item.text}>"><{$item.text}></a>
                <ul>
                    <{foreach item=sub from=$item.menu}>
                        <li>
                        <{if $sub.options != 0}>
                            <a href="<{$sub.link}>" title="<{$sub.title}>"><{$sub.title}></a>
                            <ul>
                            <{foreach item=option from=$sub.options}>
                                <li><a href="<{$sub.url}><{$option.link}>"><{$option.title}></a></li>
                            <{/foreach}>
                            </ul>
                        <{else}>
                            <a href="<{$sub.link}>" title="<{$sub.title}>"><{$sub.title}></a>
                        <{/if}>
                        </li>
                    <{/foreach}>
                </ul>
            <{else}>
                <a href="<{$item.link}>"><{$item.text}></a>
            <{/if}>
          </li>
        <{/foreach}>
    </ul>
</nav>
