/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.util.concurrent.BlockingQueue;
import javax.swing.JProgressBar;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.filepanel.FilePanel;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FileUploadManagerThread;
import wjhk.jupload2.upload.UploadFileData;
import wjhk.jupload2.upload.UploadFileDataPoisonned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePreparationThread
extends Thread {
    FileData[] fileDataArray = null;
    int nbPreparedFiles = 0;
    int nbFilesToSent = -1;
    long nbTotalNumberOfPreparedBytes = 0L;
    JProgressBar preparationProgressBar = null;
    JUploadPanel uploadPanel = null;
    UploadPolicy uploadPolicy = null;
    FileUploadManagerThread fileUploadManagerThread = null;
    FilePanel filePanel = null;
    BlockingQueue<UploadFileData> preparedFileQueue = null;

    public FilePreparationThread(BlockingQueue<UploadFileData> preparedFileQueue, FileUploadManagerThread fileUploadManagerThread, UploadPolicy uploadPolicy) {
        super("FilePreparationThread");
        this.preparedFileQueue = preparedFileQueue;
        this.fileUploadManagerThread = fileUploadManagerThread;
        this.uploadPolicy = uploadPolicy;
        this.uploadPanel = uploadPolicy.getContext().getUploadPanel();
        this.filePanel = this.uploadPanel.getFilePanel();
        this.preparationProgressBar = this.uploadPanel.getPreparationProgressBar();
        this.fileDataArray = this.uploadPanel.getFilePanel().getFiles();
        this.nbFilesToSent = this.fileDataArray.length;
        this.preparationProgressBar.setMaximum(100 * this.fileDataArray.length);
    }

    @Override
    public final void run() {
        int numFileInCurrentUpload = 0;
        for (int i = 0; i < this.fileDataArray.length && !this.fileUploadManagerThread.isUploadFinished(); ++i) {
            try {
                UploadFileData uploadFileData = new UploadFileData(this.fileDataArray[i], numFileInCurrentUpload, this.fileUploadManagerThread, this.uploadPolicy);
                this.uploadPolicy.displayDebug("============== Start of file preparation (" + uploadFileData.getFileName() + ")", 30);
                this.preparationProgressBar.setString(this.uploadPolicy.getLocalizedString("preparingFile", i + 1, this.fileDataArray.length));
                this.preparationProgressBar.repaint(0L);
                this.uploadPolicy.displayDebug(this.getClass().getName() + ".prepareFiles(): before call to beforeUpload()", 100);
                try {
                    uploadFileData.beforeUpload();
                    ++numFileInCurrentUpload;
                    this.uploadPolicy.displayDebug("============== End of file preparation (" + uploadFileData.getFileName() + ")", 30);
                    try {
                        this.anotherFileIsPrepared(uploadFileData);
                    }
                    catch (InterruptedException e) {
                        --i;
                    }
                }
                catch (JUploadException e) {
                    --this.nbFilesToSent;
                    throw e;
                }
                this.preparationProgressBar.setValue(this.nbPreparedFiles * 100);
                this.preparationProgressBar.repaint();
                continue;
            }
            catch (JUploadException e) {
                this.fileUploadManagerThread.setUploadException(e);
            }
        }
        try {
            this.preparedFileQueue.put(new UploadFileDataPoisonned());
        }
        catch (InterruptedException e) {
            this.uploadPolicy.displayWarn("Got interrupted, while posting the poisoned UploadFileData on the preparedQueue!");
        }
        this.preparationProgressBar.setString("");
    }

    private void anotherFileIsPrepared(UploadFileData newlyPreparedFileData) throws JUploadException, InterruptedException {
        ++this.nbPreparedFiles;
        this.uploadPolicy.displayDebug(this.getClass().getName() + ".anotherFileIsReady(): before call(1) to newlyPreparedFileData.getUploadLength()", 100);
        this.uploadPolicy.displayDebug(this.getClass().getName() + ".checkIfNextPacketIsReady(): before call(2) to currentFileData.getUploadLength()", 100);
        this.nbTotalNumberOfPreparedBytes += newlyPreparedFileData.getUploadLength();
        this.preparedFileQueue.put(newlyPreparedFileData);
    }

    public double getTotalFileBytesToSend() {
        double totalFileBytesToSend = this.nbPreparedFiles == this.fileDataArray.length ? (double)this.nbTotalNumberOfPreparedBytes : (double)(this.nbTotalNumberOfPreparedBytes + (long)(this.fileDataArray.length - this.nbPreparedFiles) * this.nbTotalNumberOfPreparedBytes / (long)this.nbPreparedFiles);
        return totalFileBytesToSend;
    }

    public int getNbPreparedFiles() {
        return this.nbPreparedFiles;
    }

    public int getNbFilesToSent() {
        return this.nbFilesToSent;
    }

    public long getNbTotalNumberOfPreparedBytes() {
        return this.nbTotalNumberOfPreparedBytes;
    }
}

